#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// idk what to call thisMod01.fsh  by   SnoopethDuckDuck
//https://www.shadertoy.com/view/stV3Wd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pi 3.14159

float thc(float a, float b) {
    return tanh(a * cos(b)) / tanh(a);
}

float ths(float a, float b) {
    return tanh(a * sin(b)) / tanh(a);
}

vec2 thc(float a, vec2 b) {
    return tanh(a * cos(b)) / tanh(a);
}

vec2 ths(float a, vec2 b) {
    return tanh(a * sin(b)) / tanh(a);
}

float sinc( float x, float k )
{
    float a = pi * (k*x-1.0);
    return sin(a)/a;
}

vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

float h21 (vec2 a) {
    return fract(sin(dot(a.xy, vec2(12.9898, 78.233))) * 43758.5453123);
}

float mlength(vec2 uv) {
    return max(abs(uv.x), abs(uv.y));
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-0.5*iResolution.xy)/iResolution.y;
    
    float sc = 12.;
    vec2 ipos = floor(sc * uv) + 0.5;
    vec2 fpos = fract(sc * uv) - 0.5;
    
    float t = (1. / cosh(30. * cos(0.5 * iTime))) *  h21(ipos) + iTime;
    
    //uv = fract(2. * uv)-0.5;
    float a = atan(uv.y, uv.x);
    float r = length(uv);
    
    //a = a + 10. * r - iTime + 0.1 * cos(10. * r + 10. * a - iTime);
    uv = r * vec2(thc(1., a), ths(1., a));

    float p = mix(0.1, 0.5, 0.5 - 0.5 * thc(4., 0.43 * t));
    float q = pi * (p * uv.x);
    float h = sin(q) / q;
    
    //uv.y += abs(uv.x) - 0.2;
    
    float k0 = mix(0.1, 0.2, 0.5 + 0.5 * cos(t));
    float k = k0 + 0.025 * thc(4., 32. * uv.x + t + 10. * thc(4., t));
    float f = (0.5 - k) * thc(2., 32. * h + 1.5 * t) - 0.;
    float s = smoothstep(-k, k, f - uv.y);
    
    vec3 col = vec3(s);

    col = s * pal(9. * s + 0.8 * uv.y * thc(12000., 10. * f + t), vec3(1.), vec3(1.), vec3(1.), 0.2 * vec3(0.,0.33,0.66));
    // Output to screen
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

